VERSION 5.00
Begin VB.MDIForm MDIfrmMain 
   AutoShowChildren=   0   'False
   BackColor       =   &H8000000C&
   Caption         =   "ANT Parallel Check"
   ClientHeight    =   8550
   ClientLeft      =   165
   ClientTop       =   855
   ClientWidth     =   15240
   LinkTopic       =   "MDIForm1"
   NegotiateToolbars=   0   'False
   StartUpPosition =   3  'Windows ̊l
   Begin VB.Menu Menu_Connect 
      Caption         =   "Connect(&C)"
      Begin VB.Menu Menu_ConnectOFF 
         Caption         =   "OFF(&F)"
         Checked         =   -1  'True
      End
      Begin VB.Menu Menu_ConnectON 
         Caption         =   "ON(&N)"
      End
   End
   Begin VB.Menu Menu_BorardIP_Setup 
      Caption         =   "Setup(&S)"
      Begin VB.Menu Menu_ConnectBD 
         Caption         =   "Board Number(&B)"
      End
      Begin VB.Menu Menu_ConectIP 
         Caption         =   "IP Address(&I)"
      End
      Begin VB.Menu Menu_ExtTrigger 
         Caption         =   "Ext Trigger(&E)"
      End
   End
   Begin VB.Menu Menu_SingleTest 
      Caption         =   "Test(&T)"
   End
   Begin VB.Menu Menu_ExtTrg 
      Caption         =   "Ext Trg(&E)"
      Begin VB.Menu ExtTriggerOff 
         Caption         =   "Ext Trigger OFF(&F)"
         Checked         =   -1  'True
      End
      Begin VB.Menu ExtTriggerOn 
         Caption         =   "Ext Trigger ON(&N)"
      End
   End
   Begin VB.Menu Menu_Lot 
      Caption         =   "Lot(&L)"
      Begin VB.Menu Menu_LotStart 
         Caption         =   "Start All (&S)"
      End
      Begin VB.Menu Menu_LotEnd 
         Caption         =   "End All (&E)"
         Checked         =   -1  'True
      End
   End
   Begin VB.Menu Menu_Tool 
      Caption         =   "Tool(&T)"
      Enabled         =   0   'False
      Visible         =   0   'False
      Begin VB.Menu Menu_CpCal 
         Caption         =   "Copy Cal(&C)"
      End
   End
End
Attribute VB_Name = "MDIfrmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function GetSystemMenu Lib "user32" (ByVal hwnd As Long, ByVal bRevert As Long) As Long
Private Declare Function EnableMenuItem Lib "user32" (ByVal hMenu As Long, ByVal wIDEnableItem As Long, ByVal wEnable As Long) As Long
Private Declare Function DeleteMenu Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long) As Long
Private Declare Function ModifyMenu Lib "user32" Alias "ModifyMenuA" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpString As String) As Long
Private Declare Function DrawMenuBar Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long

Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128
End Type

Private Const VER_PLATFORM_WIN32_WINDOWS = 1
Private Const VER_PLATFORM_WIN32_NT = 2

Private Const MF_DISABLED = &H2&
Private Const MF_ENABLED = &H0&
Private Const SC_CLOSE = &HF060&

Private Const MF_BYPOSITION = &H400&

'********************
' System Information
'********************
Private Sub GetIdn()
    Dim lngErr As Long
    Dim idn As String * 80
    Dim n As Long
    Dim m As Long
    Dim mdl As String
    Dim sno As String
    
    '*** Reading model name ***
    lngErr = QrySystIden(lngPID, idn)
    n = InStr(idn, ",") + 1
    m = InStr(Mid(idn, n), ",")
    NA_ConnectProductName = Mid(idn, n, m - 1)
    NA_ProductName = NA_ConnectProductName
    n = n + m
    m = InStr(Mid(idn, n), ",")
    NA_SerialNumber = Mid(idn, n, m - 1)
    mdl = "ANT Parallel Check << Ver " & App.Major & "." & Format(App.Minor, "0") & Format(App.Revision, "00") & " >>"
    TitleCaption = mdl & " [ " & NA_ProductName & " / " & NA_SerialNumber & " ]"
    Me.Caption = TitleCaption
    
    '*** Reading exp sw-box model type ***
    lngExpSwBox = SWBOX_SP4T 'lngErr = QryPioIn(lngPID, lngExpSwBox)
    
End Sub


'**********************
' CSV t@Cǂݍ
'**********************
Private Sub RdCsvFileSetup(ByVal fn As String)
    Dim ch As Long
    Dim i As Integer
    Dim ii As Integer
    Dim strFmt As String
    Dim lngErr As Long
    Dim denominator As Double
    Dim fn_cal As String
    Dim calrecallchk As Boolean
    Dim f_time As Date 'SYSTEMTIMEREC
    Dim fcal_time As Date 'SYSTEMTIMEREC
    Dim tmp As Long

    RdCsvInfo.RdFileSetup = True                                            't@Cǂݎ蒆tOEZbg
    If ReadCsvFile(fn) = True Then RdCsvInfo.RdFileSetup = False: Exit Sub  'CSVǂݎG[? -> yes : Exit
    Call GetFileTimeStamp(fn, f_time)                                       'Get .CSV File Time Stamp
    strCsvFileName = fn
    MDIfrmMain.Caption = TitleCaption & "   " & FindFileName(fn)
    
    lngErr = BisPioOut(lngPID, RdCsvInfo.IniPio)                            'pI/Oo
    For ch = ACT_CH1 To RdCsvInfo.ChNum - 1                                 'CSVœǂݎCHݒ萔[v
        If MeasureChAdd(CH_ADD_NO_INIT) = True Then
            CH_RbwChg(ch) = RBW_NRM
            frm_CH(ch).Text_LotDataSvFileName.Text = RemoveExtension(FindFileName(fn)) & "_CH" & CStr(ch + 1)
            frm_CH(ch).Check_FailDataSave.Value = lngFailSv
            lngErr = BisPioOut(lngPID, ChInfo(lngACh).Pio)  'pI/Oo
            lngErr = BisMeasAct(lngPID, lngACh + 1)         'Active CH Change
            lngErr = QrySensFunc(lngPID, tmp)               'Dummy Meas read
            lngErr = BisSensFunc(lngPID, tmp)
            With frm_CH(ch)
                .Check_TraceDraw.Value = ChInfo(ch).intWaveDisp
                If ChInfo(ch).CorMeth = BIS_CAL_NORM Then   'Cal Meth = Normalize
                    .Cmd_calib(0).Enabled = False           'Open {^
                    .Cmd_calib(1).Enabled = False           'Short {^
                    .Cmd_calib(2).Enabled = False           'Load {^
                    .Cmd_calib(3).Enabled = False           'Done {^
                Else
                    .Cmd_calib(5).Enabled = False           'Normalize {^
                End If
'                Call frmCH.CalButtonEnableCtrl(ch, False)   'Cal {^(Clear{^܂Ŗj
                .VScroll_StimNo.Min = ChInfo(ch).StimuNum - 1
            End With
            
            With CH_Stimu(ChInfo(ch).StimuNum - 1, ch)
                If .sngPow1 = .sngPow2 Then
                    frm_CH(ch).Check_pw2.Value = 0
                Else
                    frm_CH(ch).Check_pw2.Value = 1
                End If
            End With
                                    
            ' Cal Data Clear
            lngErr = BisSensCorrCollDel(lngPID)
            With ChInfo(ch).Correct
                If .CorOn <> 0 Then
                    .CorOn = 0
                    For i = BUTTON_OPEN To BUTTON_DONE
                        .CorAcq(i) = 0
                        frm_CH(ch).Cmd_calib(i).BackColor = CAL_BTN_COLOR
                    Next i
                End If
            End With
            
            'Cal Kit Type & PortSex ݒ
            lngErr = BisSensCorrCkitType(lngPID, BIS_PORT1, CKit.PortSex, CKit.CKitType)
            'Cal Type(Norm, 1 Port)ݒ
            lngErr = BisSensCorrCollMeth(lngPID, ChInfo(ch).CorMeth)
            'Cal ␳lݒ
            If 0 < InStr(NA_ProductName, "R3760") Then
                lngErr = BisSensCorrCkitUser(lngPID, BIS_PORT1, CKit.UserDef, LenB(CKit.UserDef))
            Else
                With StdCKit
                    lngErr = BisSensCorrCkitDefOpen(lngPID, .opRs, .opLs, .opCp)
                    lngErr = BisSensCorrCkitDefShor(lngPID, .shRs, .shLs, .shCp)
                    lngErr = BisSensCorrCkitDefLoad(lngPID, .loRs, .loLs, .loCp)
                End With
            End If
                          
            Call get_stim(frm_CH(ch), ch, cnt_FILE_RECALL)
            Call set_stim(frm_CH(ch), ch, BIS_FREQ_STRSTP)
             
             For ii = 0 To ChInfo(ch).MeasSegNum - 1
                With MeasInfo(ch, ii)
                    If .MeasType <> McrMeasPWRVAL Then
                        lngErr = QryFetcPoin(lngPID, ch + 1, .Start, .PStart)
                        lngErr = QryFetcPoin(lngPID, ch + 1, .Stop, .PStop)
                        If .MeasType <> McrMeasVAL Then
                           If .Start <> .Stop And .Stop < BufFrq(.PStop, ch) And .PStop <> 0 Then .PStop = .PStop - 1
                        End If
                        .LwLmtFrqFlg = 0: .UpLmtFrqFlg = 0
                        If 0 < .LwLmtFrq Then
                            .LwLmtFrqFlg = 1
                            lngErr = QryFetcPoin(lngPID, ch + 1, .LwLmtFrq, .PLwLmtFrq)
                        End If
                        If 0 < .UpLmtFrq Then
                            .UpLmtFrqFlg = 1
                            lngErr = QryFetcPoin(lngPID, ch + 1, .UpLmtFrq, .PUpLmtFrq)
                        End If
                    Else
                        .PStart = search_level_point(ch, ChInfo(ch).lngTotP, .Start, BufLvl, True)
                    End If
                End With
            Next ii
            
            If (ChInfo(ch).WaveFrmt And WAVE_FORMAT_LOGMAG) <> 0 Then
                frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxLgm
                frm_CH(ch).Text_scl(0).Text = CStr(ChInfo(ch).Trace.FmtScale.Mscl.ref)
                frm_CH(ch).Text_scl(1).Text = CStr(ChInfo(ch).Trace.FmtScale.Mscl.div)
                frm_CH(ch).Text_scl(2).Text = CStr(ChInfo(ch).Trace.FmtScale.Mscl.pos)
                lngErr = QryFetcPoin(lngPID, ch + 1, LimitFreqLvl(ch).LwFreq, LimitFreqLvl(ch).LwFreqP)
                lngErr = QryFetcPoin(lngPID, ch + 1, LimitFreqLvl(ch).UpFreq, LimitFreqLvl(ch).UpFreqP)
            ElseIf (ChInfo(ch).WaveFrmt And WAVE_FORMAT____SWR) <> 0 Then
                frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxSwr
                frm_CH(ch).Text_scl(0).Text = CStr(ChInfo(ch).Trace.FmtScale.SWRscl.ref)
                frm_CH(ch).Text_scl(1).Text = CStr(ChInfo(ch).Trace.FmtScale.SWRscl.div)
                frm_CH(ch).Text_scl(2).Text = CStr(ChInfo(ch).Trace.FmtScale.SWRscl.pos)
                lngErr = QryFetcPoin(lngPID, ch + 1, LimitFreqLvl(ch).LwFreq, LimitFreqLvl(ch).LwFreqP)
                lngErr = QryFetcPoin(lngPID, ch + 1, LimitFreqLvl(ch).UpFreq, LimitFreqLvl(ch).UpFreqP)
           End If
            Call frmCH.ChFrmtChkBoxSet(ch, frm_CH(ch))
       End If
        Call meas_disp_ctrl(frm_CH(ch))
        Call meas_opt_disp(frm_CH(ch), ChInfo(ch).SelectMeasType)
    Next ch
    
    Call LCR_MeasPackage(RdCsvInfo.ChNum)     '**** LCR ꊇ܂Ƃߏグ ***

    '**********************
    ' Cal Data File Recall
    '**********************
    fn_cal = Mid(fn, 1, Len(fn) - 3)
    fn_cal = fn_cal & "bin"
    If FileDlg.FileExists(fn_cal) = True Then
        Call GetFileTimeStamp(fn_cal, fcal_time)            'Get .CSV File Time Stamp
        calrecallchk = ChkFileTimeStamp(f_time, fcal_time)  'Check .CSV vs .BIN File Time Stamp Check
        If lngCalReadChk And calrecallchk = False Then
            If MsgBox("Is the correction data compulsorily read?", vbYesNo) = vbYes Then
                calrecallchk = True
                If MsgBox("Is the time stamp of the correction data renewed?", vbYesNo) = vbYes Then Call SetLastWriteTime(fn_cal, Now)
            End If
        End If
        If calrecallchk = True Then
            Call ReadCalFile(RdCsvInfo.ChNum, fn_cal)           'Read Calibration file
            For ch = 0 To RdCsvInfo.ChNum - 1                   'CSVœǂݎCHݒ萔[v
                With ChInfo(ch)
                    lngErr = meas_ch(ch)
                    lngErr = BisSensCorrCollDel(lngPID)
                    lngErr = BisSensCorrCollMeth(lngPID, .CorMeth)
                    lngErr = BisTracData(lngPID, .TrCa1, 0, .lngTotP - 1, .Correct.cal1(0), .lngTotP * 8)
                    lngErr = BisTracData(lngPID, .TrCa2, 0, .lngTotP - 1, .Correct.cal2(0), .lngTotP * 8)
                    lngErr = BisTracData(lngPID, .TrCa3, 0, .lngTotP - 1, .Correct.cal3(0), .lngTotP * 8)
                End With
                lngErr = BisSensCorrCsetStat(lngPID, BIS_ON)
                lngErr = QrySensCorrCsetStat(lngPID, ChInfo(ch).Correct.CorOn)
                Call frm_CH(ch).CalButtonBackColorCtrl(ch, CAL_COR_COLOR)
                Call frm_CH(ch).CalButtonEnableCtrl(ch, False)
                frm_CH(ch).Check_cal.Enabled = False: frm_CH(ch).Check_cal.Value = ChInfo(ch).Correct.CorOn: frm_CH(ch).Check_cal.Enabled = True
            Next ch
        End If
    End If

    RdCsvInfo.CorrStat = get_ChCorChk(ChNum)
    
    RdCsvInfo.RdFileSetup = False

End Sub

'**************************
' t@CE_CAO\
'**************************
Private Sub OpenFileDlg()
    Dim bln As Boolean
    Dim fn As String

    fn = FileDlg.OpenFileDg(frmSetup.dlgFILE, strSetupPathFileAtt, "READ", bln)
    If fn = vbNullString Then Exit Sub                      't@CI𖳂? -> yes : Exit
    strSetupPathFileAtt = RemoveFileSpec(fn)                't@CEpX𒊏o
    Call WriteIniFile_SetupFileDlgPath(strSetupPathFileAtt) 'ini t@CɃt@CEpXۑ
    
    Call RdCsvFileSetup(fn)                                 'CSVt@C̃ZbgEAbv

End Sub

'*******************************
'lbg[NEAiCUƐڑ
'*******************************
Private Function ConnectOnOff(Index As Integer) As Long
    Dim l As Long
    Dim lngErr As Long
    
    ConnectOnOff = 0
    If Index = BIS_OFF Then
        TcpConnect = False
        lngExpSwBox = SWBOX_NONC        'gSW-BOX^Cv Non Connect
        RdCsvInfo.CorrStat = False
        ExitFlag = 1
    Else
        If lngPID <> 0 Then Exit Function
        lngErr = BisOpenPacket(strIpAddress, CStr(BoardNo), lngPID)
        ConnectOnOff = lngErr
    End If

End Function

Private Sub MDIForm_Resize()
    Dim ch As Long
    
    For ch = 0 To ChNum - 1                         '`l
        If frm_CH(ch).WindowState = 0 Then
            Call FrmWindResize(ch)
        End If
    Next ch
End Sub

Private Sub Menu_ConnectBD_Click()
    frmSetup.Show
End Sub

Private Sub Menu_ConectIP_Click()
    frmSetup.Show
End Sub

Private Sub Menu_CpCal_Click()
    frmCalCopy.Show
End Sub

Private Sub Menu_ExtTrigger_Click()
    frmSetup.Show
End Sub


Private Sub ExtTriggerOff_Click()
    Dim lngErr As Long
    
    lngErr = BisAbor(lngPID)    '|~
    lngErr = BisTrigSour(lngPID, INTERNAL, 0)   'Internal Trigger
    
    Menu_SingleTest.Enabled = True
    ExtTriggerOff.Checked = True
    ExtTriggerOn.Checked = False
    ContinuousSweep = False
    Call Scale_EnableCntrl(RdCsvInfo.ChNum - 1, True)
    ContFlag = 0
End Sub

Private Sub ExtTriggerOn_Click()
    Menu_SingleTest.Enabled = False
    ExtTriggerOn.Checked = True
    ExtTriggerOff.Checked = False
    ContinuousSweep = True
    Call Scale_EnableCntrl(RdCsvInfo.ChNum - 1, False)
    ContFlag = 1
End Sub

Private Sub MemoryRelease()
    Dim i As Integer
    Dim j As Integer
    Dim k As Integer
    Dim strCh As String
    
    If RdCsvInfo.ChNum <> 0 Then
        If UBound(ChInfo) Then Erase ChInfo
        If UBound(MeasInfo) Then Erase MeasInfo
        If RdCsvInfo.RdFileSetup = True Then If UBound(MeasData) Then Erase MeasData
        MeasItemNum = 0
        RdCsvInfo.ChNum = 0
    End If
    
    For i = ACT_CH1 To MAX_CH
        If intFrmCh(i) Then
            Call Unload(frm_CH(i))
        End If
        Set frm_CH(i) = Nothing
        CH_RbwChg(i) = RBW_NRM
    Next i
    
End Sub

Private Sub Menu_ConnectOFF_Click()
    Dim lngErr As Long

    Call MemoryRelease
    Call ExtTriggerOff_Click
    
    Menu_ConnectOFF.Checked = True
    Menu_ConnectON.Checked = False
    Menu_SingleTest.Enabled = False
    Menu_ExtTrg.Enabled = False
    Menu_Lot.Enabled = False
    If lngToolMenu Then
        Menu_Tool.Visible = True
        Menu_Tool.Enabled = False
    End If
    Call MDIfrmMain.EnblCtrl(True)
    
    lngErr = ConnectOnOff(BIS_OFF)
    DuringBootUp = True
End Sub

Private Sub Menu_ConnectON_Click()
    Dim lngErr As Long
    
    lngErr = ConnectOnOff(BIS_ON)
    
    ' ڑ̊mF
    If lngErr <> 0 Then
        lngErr = MsgBox("Invalid open the Communication Port.(" & str(lngErr) & ")", vbOKOnly)
        
        ExtTriggerOff.Checked = True
        ExtTriggerOn.Checked = False
        Menu_SingleTest.Enabled = False
        Menu_ExtTrg.Enabled = False
        Menu_Lot.Enabled = False
        If lngToolMenu Then
            Menu_Tool.Visible = True
            Menu_Tool.Enabled = False
        End If
        Call MDIfrmMain.EnblCtrl(True)
        lngExpSwBox = SWBOX_NONC
        TcpConnect = False
    Else
        If TcpConnect = False Then
            Call WriteIniFile_IP_Adrs(strIpAddress)
            
            '@^Cvǂݎ
            Call GetIdn
            
            'lbg[NEAiCUEvZbgij
            lngErr = BisSystPres(lngPID)
            
            'A|
            lngErr = BisInitCont(lngPID, BIS_OFF)
            If ContinuousSweep = True Then ContinuousSweep = False
    
            If ExtTriggerOn.Checked = True Then
                lngErr = BisTrigSour(lngPID, EXTERNAL, lngPattern)  'Ext Trigger
            Else
                lngErr = BisTrigSour(lngPID, INTERNAL, 0)           'Internal Trigger
            End If
            lngErr = BisAbor(lngPID)    '|~
            
            Menu_ConnectON.Checked = True
            Menu_ConnectOFF.Checked = False
            Menu_SingleTest.Enabled = True
            Menu_ExtTrg.Enabled = True
            Menu_Lot.Enabled = True
            If lngToolMenu Then
                Menu_Tool.Visible = True
                Menu_Tool.Enabled = True
            End If
            Call MDIfrmMain.EnblCtrl(False)
            TcpConnect = True
        Else
            Call ExtTriggerOff_Click
            Call MemoryRelease
        End If
        Call OpenFileDlg
        DuringBootUp = False
        Call init_graph
    End If

End Sub

Private Sub Menu_LotEnd_Click()
    Dim ch As Long
    
    For ch = 0 To ChNum - 1                         '`l
        Call LotCntrlBtn(ch, False, IDX_LOT_END)
    Next ch
    Menu_LotEnd.Checked = True
    Menu_LotStart.Checked = False
End Sub

Private Sub Menu_LotStart_Click()
    Dim ch As Long
    
    For ch = 0 To ChNum - 1                         '`l
        Call LotCntrlBtn(ch, False, IDX_LOT_START)
    Next ch
    Menu_LotStart.Checked = True
    Menu_LotEnd.Checked = False
End Sub

Private Function Get_Wind_Type() As Integer
    Dim OSVER As OSVERSIONINFO
    
    OSVER.dwOSVersionInfoSize = Len(OSVER)
    Call GetVersionEx(OSVER)
    
    Get_Wind_Type = WIND_TYPE_01
    Select Case OSVER.dwPlatformId
        Case VER_PLATFORM_WIN32_NT
            Select Case OSVER.dwMajorVersion
                Case 5
                    Get_Wind_Type = WIND_TYPE_01
                Case 6
                    Get_Wind_Type = WIND_TYPE_02
            End Select
    End Select
End Function

Public Sub EnblCtrl(bln As Boolean)
    Dim hM As Long
    Dim i As Long
    Dim rtn As Long
    
    hM = GetSystemMenu(Me.hwnd, 0)
    
    If bln = True Then
        rtn = EnableMenuItem(hM, SC_CLOSE, MF_ENABLED)
        rtn = GetSystemMenu(Me.hwnd, 1)
    Else
        rtn = EnableMenuItem(hM, SC_CLOSE, MF_DISABLED)
        For i = 0 To 6
            Call DeleteMenu(hM, 5, MF_BYPOSITION)
        Next i
    End If
    rtn = DrawMenuBar(hM)
End Sub

'******************
' tH[E[h
'******************
Private Sub MDIForm_Load()
    Dim TitleCaption As String
    
    DuringBootUp = True             'start Boot up
    intWindType = Get_Wind_Type
    
    If intWindType = WIND_TYPE_01 Then
        intfrmCHTopOfst = FRM_CH_TOP__OFFSET
        intfrmCHLeftOfst = FRM_CH_WIDTH_OFFST
    Else
        intfrmCHTopOfst = FRM_CH_TOP__OFFSET + 90
        intfrmCHLeftOfst = FRM_CH_WIDTH_OFFST + 130
    End If
    
    strWkFolderPath = App.path & "\Temp"
    If Dir(strWkFolderPath, vbDirectory) = "" Then
        MkDir strWkFolderPath
    End If

    Menu_SingleTest.Enabled = False
    Menu_ExtTrg.Enabled = False
    Menu_Lot.Enabled = False
    Menu_Tool.Enabled = False
    Menu_Tool.Visible = False
    
    BoardNo = CInt(ReadIniFile_BD)                          'Read Board No.
    Call WriteIniFile_BD(CStr(BoardNo))
    
    strIpAddress = Trim(ReadIniFile_IP_Adrs())              'IP Address
    Call WriteIniFile_IP_Adrs(strIpAddress)
    
    strSetupPathFileAtt = ReadIniFile_SetupFileDlgPath()    'Read File Path
    Call WriteIniFile_SetupFileDlgPath(strSetupPathFileAtt)
    
    strSvMsrDtPathfileAtt = ReadIniFile_SvMsrDtFileDlgPath()    'Save File Path
    Call WriteIniFile_SvMsrDtFileDlgPath(strSvMsrDtPathfileAtt)
 
    If FileExists(strSvMsrDtPathfileAtt) = False Then strSvMsrDtPathfileAtt = App.path
    lngJdgDisp = CLng(ReadIniFile_JudgeDisplay())           'Judge Display ON/OFF
    Call WriteIniFile_JudgeDisplay(CStr(lngJdgDisp))
    
    lngJdgPosi = CLng(ReadIniFile_JudgeDispPosi())          'Judge Display Position
    Call WriteIniFile_JudgeDispPosi(CStr(lngJdgPosi))
    
    JdgFontSz = CCur(ReadIniFile_JdgFontSize())             'Judge Font Size
    Call WriteIniFile_JdgFontSize(CStr(JdgFontSz))
    
    lngRsltPosi = CLng(ReadIniFile_RsltDispPosi())          'Result Data Display Position
    Call WriteIniFile_RsltDispPosi(CStr(lngRsltPosi))
        
    RsltFontSz = CCur(ReadIniFile_RsltFontSize())           'Result Data Display Font Size
    Call WriteIniFile_RsltFontSize(CStr(RsltFontSz))
    
    lngPattern = CLng(ReadIniFile_ExtTriggerPttn())         'Ext Trigger Pattern
    Call WriteIniFile_ExtTriggerPttn(CStr(lngPattern))
    
    lngFailSv = CLng(ReadIniFile_FailDtSvChkBx())           'Fail Data File Save Flag
    Call WriteIniFile_FailDtSvChkBx(CStr(lngFailSv))
    
    strFailMark = ReadIniFile_FailMarkType()                'Fail Mark
    Call WriteIniFile_FailMarkType(strFailMark)
    
    lngCalReadChk = ReadIniFile_CalReadChk()                'Cal Read Check((Difference of time stamp)
    Call WriteIniFile_CalReadChk(CStr(lngCalReadChk))
        
    lngToolMenu = ReadIniFile_ToolMenu()                    'Tool Menu Valid / InValid
    Call WriteIniFile_ToolMenu(CStr(lngToolMenu))
    If lngToolMenu Then
        Menu_Tool.Visible = True
    End If
    
    TitleCaption = Me.Caption & "  << Ver " & App.Major & "." & Format(App.Minor, "0") & Format(App.Revision, "00") & " >>"
    Me.Caption = TitleCaption
End Sub


'**********************
' tH[EA[h
'**********************
Private Sub MDIForm_Unload(Cancel As Integer)
    Dim lngErr As Long
    
    ContFlag = 0
    ExitFlag = 0
    If lngPID Then lngErr = BisClosePacket(lngPID)
    End
End Sub

'**********************
' Single Test
'**********************
Private Sub Menu_SingleTest_Click()
    Call ExtTriggerOff_Click
    Call bna_test
End Sub
